 ; Ŀ
 ;   OnLine - insert a block on a line, don't disturb the line.            
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Short - error handler.                                                
 ; 
 (DEFUN SHORT (shk / pos entt enam sublst vall)
;  (setvar "snapmode" snapp)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Short end.                                                            
 ; 

 ; Ŀ
 ;   OnLine.                                                               
 ; 
 (DEFUN C:ONLINE (/ esav *error* snapp blnamp scal pa pb ss enam entt ten elv
                                                                         angg)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Reset error handler and snap.                                         
 ; 
  (setq esav *error*)
  (setq *error* short)
 ; (setq snapp (getvar "snapmode"))
 ; (setvar "snapmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
 ; Ŀ
 ;   Ask for a block name and an insertion point.                          
 ; 
  (if blnam
      (progn
           (setq blnamp (getstring (strcat "Block <" blnam ">: ")))
           (if (/= blnamp "") (setq blnam blnamp)))
      (setq blnam (getstring "Block: ")))
  (setq pa (getpoint "Line: "))
  (if (setq pb (osnap pa "near"))                  ; look for a near point
      (setq pa pb))                                ; if one then use it
 ; Ŀ
 ;   Decide which type of entity we are dealing with: a line...            
 ; 
  (cond ((setq ss (ssget pa (list (cons 0 "line"))))
         (setq enam (ssname ss 0))
         (setq entt (entget enam))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (setq angg (angle ten elv))
         (if (and (> angg (/ pi 2)) (<= angg (* pi 1.5)))
             (setq angg (+ angg pi)))
         (setq angg (/ (* angg 180) pi))
         (command "insert" blnam pa scal "" angg))
 ; Ŀ
 ;   ...a polyline...                                                      
 ; 
        ((setq ss (ssget pa '((-4 . "<or") (0 . "polyline")
                              (0 . "lwpolyline") (-4 . "or>"))))
         (setq psav pa)
         (setq pb (osnap pa "end"))
         (if (equal pa pb) (setq pa (osnap pa "mid")))
         (setq angg (angle pa pb))
         (if (and (> angg (/ pi 2)) (<= angg (* pi 1.5)))
             (setq angg (+ angg pi)))
         (setq angg (/ (* angg 180) pi))
         (command "insert" blnam psav scal "" angg))
 ; Ŀ
 ;   ...or empty space.                                                    
 ; 
      (t (command "insert" blnam pa scal "")))
 ; (setvar "snapmode" snapp)
  (setq *error* esav)
 (princ))